<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Site extends Model
{
    protected $fillable = [
        'name',
        'api_key',
        'api_secret',
        'allowed_domains',
        'is_active',
    ];

    protected $casts = [
        'allowed_domains' => 'array',
        'is_active' => 'boolean',
    ];

    protected $hidden = [
        'api_secret',
    ];

    public function payments()
    {
        return $this->hasMany(Payment::class);
    }
}
